/*
 * Created on Jul 8, 2003
 */
package Validators;

import Data.*;

/**
 * This class is being used for validating new Login data
 * 
 */
public class NewLoginValidator {

	private String message;
	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate new login data
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(UserData userData) {

		UserData userdata = userData;
		String password, verifier;
		password = userdata.getPassword();
		verifier = userdata.getVerifier();

		if (verifier == null || password == null) {
			message = "Either password or verify password field is empty.";
			return false;
		} else if (!verifier.equals(password)) {
			message =
				"The given password does not match the verifying password.";
			return false;
		}
		if (!password.matches("^[a-zA-Z/`/'/s]{4,30}+$")) {
			message = "Password has some invalid characters.";
			message += " Password has to be between 4 and 30 characters long. ";

			return false;
		}
		return true;

	}
}
